// $Id: CAboutWindow.cpp,v 1.5 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CAboutWindow.hpp"
#include "../Graphics/CTGAImage.hpp"
#include "../Graphics/CImageManager.hpp"
#include <Host/CDisplayInformation.hpp>
using Exponent::Host::CDisplayInformation;
using Exponent::GUI::Graphics::CTGAImage;
using Exponent::GUI::Graphics::CImageManager;
using Exponent::GUI::Windowing::CAboutWindow;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CAboutWindow, CWindow);

//	===========================================================================
CAboutWindow::CAboutWindow(const CSystemString &aboutWindowImagePath, const CString imageName, const double alpha) : CWindow(CRect(0, 0, 100, 100))
{
	EXPONENT_CLASS_CONSTRUCTION(CAboutWindow);

	// First we create the attributes
	FREE_POINTER(m_theControlRoot);
	m_theControlRoot = new CAboutRoot(this);
	this->registerDropFileListener(m_theControlRoot);
	this->registerKeyboardListener(m_theControlRoot);
	this->registerMouseListener(m_theControlRoot);

	// Create the image
	CTGAImage *image = CTGAImage::getNewInstance(aboutWindowImagePath, imageName);
	if (image)
	{
		// Set the background
		m_theControlRoot->setBackgroundImage(image);

		// Store the values for the attributes
	#ifdef WIN32
		m_attributes->initialise(WS_POPUP, WS_EX_LAYERED | WS_EX_NOACTIVATE | WS_EX_TOPMOST);
	#else
		m_attributes->initialise(kWindowNoAttributes | kWindowStandardHandlerAttribute | kWindowNoShadowAttribute, kPlainWindowClass);
		m_attributes->windowHasShadow(false);
	#endif
		m_attributes->setWindowAlphaValue(alpha);
	
		// Initialise the window
		this->initialiseWindow(m_attributes, false);
		
		const long width  = CDisplayInformation::getMonitorScreenWidth()  / 2;
		const long height = CDisplayInformation::getMonitorScreenHeight() / 2;
		
		const CPoint position(width  - image->getNormalisedImageSize().getCentralXPosition(), height - image->getNormalisedImageSize().getCentralYPosition());

		// STore the positions
		const CRect windowArea(position, image->getImageSize());

		// Now set the position and size
		this->setWindowPositionAndSize(windowArea);
	}
}

//	===========================================================================
CAboutWindow::CAboutWindow(const double alpha) : CWindow(CRect(0, 0, 100, 100))
{
	EXPONENT_CLASS_DESTRUCTION(CAboutWindow);

	// First we create the attributes
	FREE_POINTER(m_theControlRoot);
	m_theControlRoot = new CAboutRoot(this);
	this->registerDropFileListener(m_theControlRoot);
	this->registerKeyboardListener(m_theControlRoot);
	this->registerMouseListener(m_theControlRoot);

	// Create the image
	IImage *image = CImageManager::getImage("AboutWindow");//CTGAImage::getNewInstance(aboutWindowImagePath, imageName);
	if (image)
	{
		// Set the background
		m_theControlRoot->setBackgroundImage(image);

		// Store the values for the attributes
	#ifdef WIN32
		m_attributes->initialise(WS_POPUP, WS_EX_LAYERED | WS_EX_NOACTIVATE | WS_EX_TOPMOST);
	#else
		m_attributes->initialise(kWindowNoAttributes | kWindowStandardHandlerAttribute | kWindowNoShadowAttribute, kPlainWindowClass);
		m_attributes->windowHasShadow(false);
	#endif
		m_attributes->setWindowAlphaValue(alpha);
	
		// Initialise the window
		this->initialiseWindow(m_attributes, false);
		
		const long width  = CDisplayInformation::getMonitorScreenWidth()  / 2;
		const long height = CDisplayInformation::getMonitorScreenHeight() / 2;
		
		const CPoint position(width  - image->getNormalisedImageSize().getCentralXPosition(), height - image->getNormalisedImageSize().getCentralYPosition());

		// STore the positions
		const CRect windowArea(position, image->getImageSize());

		// Now set the position and size
		this->setWindowPositionAndSize(windowArea);
	}
}

//	===========================================================================
CAboutWindow::~CAboutWindow()
{
	// Nothing to do...
}

//	===========================================================================
void CAboutWindow::lostFocus(IWindow *window)
{
	this->closeWindow();
}

//	===========================================================================
#ifndef WIN32
void CAboutWindow::openWindow()
{
	// Open the window
	CWindow::openWindow();
	// Set the window group to be that of a floating window, so that Application which break the
	// Aqua L+F and use floating windows will still be able to see this window at the top of the z ordering tree...
	SetWindowGroup(this->getMutableWindowHandle()->m_windowHandle, GetWindowGroupOfClass(kFloatingWindowClass));
	CWindowTools::setFocusWindow(this->getMutableWindowHandle());
	this->updateWindow();
}
#endif